define([
    'underscore',
    'Vent',
    'modules/page/popup/warning-popup-view',
    'text!modules/connection/session-ended.html',
],
function (_, vent, WarningPopupView, template) {
    'use strict';

    return WarningPopupView.extend({
        id: 'session-ended',
        template: _.template(template),
        events: {
            'popupafteropen': 'focusOnHeader',
            'popupafterclose': 'destroy',
            'click .warning-continue-btn': 'showLaunchpad', // #session-launchpad-btn
            'click .warning-return-btn': 'showLogin', // #session-login-btn
            'click button': 'closePopup',
        },
        showLaunchpad: function() {
            vent.trigger('do:launchpad');
        },
        showLogin: function() {
            vent.trigger('do:login');
        },
    });
});
